<?php
// Default titles
$portfolio_cpt_singular_title	= esc_attr__('Portfolio','xinterio');
$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','xinterio');
$service_cpt_singular_title	= esc_attr__('Service','xinterio');
$service_cat_singular_title	= esc_attr__('Service Category','xinterio');
$team_cpt_singular_title	= esc_attr__('Team Member','xinterio');
$team_group_singular_title	= esc_attr__('Team Group','xinterio');
$testimonial_cpt_singular_title		= esc_attr__('Testimonial','xinterio');
$testimonial_cat_singular_title	= esc_attr__('Testimonial Category','xinterio');
if( class_exists('Kirki') ){
	// Portfolio
	$portfolio_cpt_singular_title2	= Kirki::get_option( 'portfolio-cpt-singular-title' );
	$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;
	// Portfolio Category
	$portfolio_cat_singular_title2	= Kirki::get_option( 'portfolio-cat-singular-title' );
	$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;
	// Service
	$service_cpt_singular_title2	= Kirki::get_option( 'service-cpt-singular-title' );
	$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;
	// Service Category
	$service_cat_singular_title2	= Kirki::get_option( 'service-cat-singular-title' );
	$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;
	// Team
	$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
	$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;
	// Team Group
	$team_group_singular_title2	= Kirki::get_option( 'team-group-singular-title' );
	$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;
	// Testimonial
	$testimonial_cpt_singular_title2	= Kirki::get_option( 'testimonial-cpt-singular-title' );
	$testimonial_cpt_singular_title	= ( !empty($testimonial_cpt_singular_title2) ) ? $testimonial_cpt_singular_title2 : $testimonial_cpt_singular_title ;
	// Testimonial Category
	$testimonial_cat_singular_title2	= Kirki::get_option( 'testimonial-cat-singular-title' );
	$testimonial_cat_singular_title	= ( !empty($testimonial_cat_singular_title2) ) ? $testimonial_cat_singular_title2 : $testimonial_cat_singular_title ;
}
$pre_color_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_color_with_gradient_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'gradientcolor'		=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_two_color_list = array(
	''					=> get_template_directory_uri() . '/includes/images/precolor-default.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
);
$pre_text_color_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
);
$pre_text_color_2_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
);
$column_list = array(
	'1'	=> get_template_directory_uri() . '/includes/images/column-1.png',
	'2'	=> get_template_directory_uri() . '/includes/images/column-2.png',
	'3'	=> get_template_directory_uri() . '/includes/images/column-3.png',
);
// Total Header Styles
$header_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/header-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/header-style-2.jpg',
	'3'	=> get_template_directory_uri() . '/includes/images/header-style-3.jpg',
	'4'	=> get_template_directory_uri() . '/includes/images/header-style-4.jpg',
	'5'	=> get_template_directory_uri() . '/includes/images/header-style-5.jpg',
	'6'	=> get_template_directory_uri() . '/includes/images/header-style-6.jpg',
	'7'	=> get_template_directory_uri() . '/includes/images/header-style-7.jpg',
	'8'	=> get_template_directory_uri() . '/includes/images/header-style-8.jpg',
	'9'	=> get_template_directory_uri() . '/includes/images/header-style-9.jpg',
	'10'=> get_template_directory_uri() . '/includes/images/header-style-10.jpg',
);
// Total Single Portfolio Styles
$portfolio_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-2.jpg',
);
// Total Single Service Styles
$service_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/service-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/service-single-style-2.jpg',
);
// Total Single Team Styles
$team_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/team-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/team-single-style-2.jpg',
);
// Social links
$social_options_array = array();
if( function_exists('pbmit_social_links_list') ){
	$social_list = pbmit_social_links_list();
	foreach( $social_list as $social ){
		$social_options_array[] = array(
			'type'			=> 'text',
			'settings'		=> esc_attr( $social['id'] ),
			'label'			=> esc_attr( $social['label'] ),
			'description'	=> esc_attr__( 'Write Social URL.', 'xinterio' ),
			'default'		=> '',
		);
	}
}
$footer_col_width_array = array(
	'hide'	=> esc_attr__( 'Hide this column', 'xinterio' ),
	'1'		=> esc_attr__( '1%', 'xinterio' ),
	'2'		=> esc_attr__( '2%', 'xinterio' ),
	'3'		=> esc_attr__( '3%', 'xinterio' ),
	'4'		=> esc_attr__( '4%', 'xinterio' ),
	'5'		=> esc_attr__( '5%', 'xinterio' ),
	'6'		=> esc_attr__( '6%', 'xinterio' ),
	'7'		=> esc_attr__( '7%', 'xinterio' ),
	'8'		=> esc_attr__( '8%', 'xinterio' ),
	'9'		=> esc_attr__( '9%', 'xinterio' ),
	'10'	=> esc_attr__( '10%', 'xinterio' ),
	'11'	=> esc_attr__( '11%', 'xinterio' ),
	'12'	=> esc_attr__( '12%', 'xinterio' ),
	'13'	=> esc_attr__( '13%', 'xinterio' ),
	'14'	=> esc_attr__( '14%', 'xinterio' ),
	'15'	=> esc_attr__( '15%', 'xinterio' ),
	'16'	=> esc_attr__( '16%', 'xinterio' ),
	'17'	=> esc_attr__( '17%', 'xinterio' ),
	'18'	=> esc_attr__( '18%', 'xinterio' ),
	'19'	=> esc_attr__( '19%', 'xinterio' ),
	'20'	=> esc_attr__( '20%', 'xinterio' ),
	'21'	=> esc_attr__( '21%', 'xinterio' ),
	'22'	=> esc_attr__( '22%', 'xinterio' ),
	'23'	=> esc_attr__( '23%', 'xinterio' ),
	'24'	=> esc_attr__( '24%', 'xinterio' ),
	'25'	=> esc_attr__( '25%', 'xinterio' ),
	'26'	=> esc_attr__( '26%', 'xinterio' ),
	'27'	=> esc_attr__( '27%', 'xinterio' ),
	'28'	=> esc_attr__( '28%', 'xinterio' ),
	'29'	=> esc_attr__( '29%', 'xinterio' ),
	'30'	=> esc_attr__( '30%', 'xinterio' ),
	'31'	=> esc_attr__( '31%', 'xinterio' ),
	'32'	=> esc_attr__( '32%', 'xinterio' ),
	'33'	=> esc_attr__( '33%', 'xinterio' ),
	'34'	=> esc_attr__( '34%', 'xinterio' ),
	'35'	=> esc_attr__( '35%', 'xinterio' ),
	'36'	=> esc_attr__( '36%', 'xinterio' ),
	'37'	=> esc_attr__( '37%', 'xinterio' ),
	'38'	=> esc_attr__( '38%', 'xinterio' ),
	'39'	=> esc_attr__( '39%', 'xinterio' ),
	'40'	=> esc_attr__( '40%', 'xinterio' ),
	'41'	=> esc_attr__( '41%', 'xinterio' ),
	'42'	=> esc_attr__( '42%', 'xinterio' ),
	'43'	=> esc_attr__( '43%', 'xinterio' ),
	'44'	=> esc_attr__( '44%', 'xinterio' ),
	'45'	=> esc_attr__( '45%', 'xinterio' ),
	'46'	=> esc_attr__( '46%', 'xinterio' ),
	'47'	=> esc_attr__( '47%', 'xinterio' ),
	'48'	=> esc_attr__( '48%', 'xinterio' ),
	'49'	=> esc_attr__( '49%', 'xinterio' ),
	'50'	=> esc_attr__( '50%', 'xinterio' ),
	'51'	=> esc_attr__( '51%', 'xinterio' ),
	'52'	=> esc_attr__( '52%', 'xinterio' ),
	'53'	=> esc_attr__( '53%', 'xinterio' ),
	'54'	=> esc_attr__( '54%', 'xinterio' ),
	'55'	=> esc_attr__( '55%', 'xinterio' ),
	'56'	=> esc_attr__( '56%', 'xinterio' ),
	'57'	=> esc_attr__( '57%', 'xinterio' ),
	'58'	=> esc_attr__( '58%', 'xinterio' ),
	'59'	=> esc_attr__( '59%', 'xinterio' ),
	'60'	=> esc_attr__( '60%', 'xinterio' ),
	'61'	=> esc_attr__( '61%', 'xinterio' ),
	'62'	=> esc_attr__( '62%', 'xinterio' ),
	'63'	=> esc_attr__( '63%', 'xinterio' ),
	'64'	=> esc_attr__( '64%', 'xinterio' ),
	'65'	=> esc_attr__( '65%', 'xinterio' ),
	'66'	=> esc_attr__( '66%', 'xinterio' ),
	'67'	=> esc_attr__( '67%', 'xinterio' ),
	'68'	=> esc_attr__( '68%', 'xinterio' ),
	'69'	=> esc_attr__( '69%', 'xinterio' ),
	'70'	=> esc_attr__( '70%', 'xinterio' ),
	'71'	=> esc_attr__( '71%', 'xinterio' ),
	'72'	=> esc_attr__( '72%', 'xinterio' ),
	'73'	=> esc_attr__( '73%', 'xinterio' ),
	'74'	=> esc_attr__( '74%', 'xinterio' ),
	'75'	=> esc_attr__( '75%', 'xinterio' ),
	'76'	=> esc_attr__( '76%', 'xinterio' ),
	'77'	=> esc_attr__( '77%', 'xinterio' ),
	'78'	=> esc_attr__( '78%', 'xinterio' ),
	'79'	=> esc_attr__( '79%', 'xinterio' ),
	'80'	=> esc_attr__( '80%', 'xinterio' ),
	'81'	=> esc_attr__( '81%', 'xinterio' ),
	'82'	=> esc_attr__( '82%', 'xinterio' ),
	'83'	=> esc_attr__( '83%', 'xinterio' ),
	'84'	=> esc_attr__( '84%', 'xinterio' ),
	'85'	=> esc_attr__( '85%', 'xinterio' ),
	'86'	=> esc_attr__( '86%', 'xinterio' ),
	'87'	=> esc_attr__( '87%', 'xinterio' ),
	'88'	=> esc_attr__( '88%', 'xinterio' ),
	'89'	=> esc_attr__( '89%', 'xinterio' ),
	'90'	=> esc_attr__( '90%', 'xinterio' ),
	'91'	=> esc_attr__( '91%', 'xinterio' ),
	'92'	=> esc_attr__( '92%', 'xinterio' ),
	'93'	=> esc_attr__( '93%', 'xinterio' ),
	'94'	=> esc_attr__( '94%', 'xinterio' ),
	'95'	=> esc_attr__( '95%', 'xinterio' ),
	'96'	=> esc_attr__( '96%', 'xinterio' ),
	'97'	=> esc_attr__( '97%', 'xinterio' ),
	'98'	=> esc_attr__( '98%', 'xinterio' ),
	'99'	=> esc_attr__( '99%', 'xinterio' ),
	'100'	=> esc_attr__( '100%', 'xinterio' ),
);
$blog_styles = pbmit_element_template_list('blog', 'customizer');
unset($blog_styles['classic'], $blog_styles['2']);
/*** Options array ***/
$kirki_options_array = array(
	// General Settings
	'general_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'General Options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'color',
				'settings'		=> 'global-color',
				'label'			=> esc_attr__( 'Global Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This color will be globally applied to most of elements parts and special texts', 'xinterio' ),
				'default'		=> '#bb9a65',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'secondary-color',
				'label'			=> esc_attr__( 'Secondary Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This color will be used on some elements. Sometimes with Global Color. This should match with Global Color to look good.', 'xinterio' ),
				'default'		=> '#403226',
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'gradient-color',
				'label'		=> esc_attr__( 'Gradient Color', 'xinterio' ),
				'choices'		=> array(
					'first'		=> esc_attr__( 'Starting Color', 'xinterio' ),
					'last'		=> esc_attr__( 'Ending Color', 'xinterio' ),
				),
				'default'	=> array(
				'first'		=> '#bb9a65',
				'last'		=> '#baae9e',
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'logo',
				'label'				=> esc_attr__( 'Logo', 'xinterio' ),
				'description'		=> esc_attr__( 'Main logo', 'xinterio' ),
				'default'			=> get_template_directory_uri() . '/images/logo.svg',
				'partial_refresh'	=> array(
					'logo'				=> array(
						'selector'			=> '.site-title',
						'render_callback'	=> function() {
							return pbmit_logo( 'yes' );
						},
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'logo-height',
				'label'			=> esc_attr__( 'Logo Max Height', 'xinterio' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'sticky-logo',
				'label'			=> esc_attr__( 'Sticky Logo', 'xinterio' ),
				'description'	=> esc_attr__( 'Sticky logo', 'xinterio' ),
				'default'		=> '',
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-logo-height',
				'label'			=> esc_attr__( 'Sticky Logo Max Height', 'xinterio' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'responsive-logo',
				'label'			=> esc_attr__( 'Responsive Logo', 'xinterio' ),
				'description'	=> esc_attr__( 'This logo appear in small devices like mobile/tablet etc', 'xinterio' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-logo-height',
				'label'			=> esc_attr__( 'Responsive Logo Max Height', 'xinterio' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'link-color',
				'label'		=> esc_attr__( 'Link Color', 'xinterio' ),
				'choices'		=> array(
					'normal'	=> esc_attr__( 'Normal Color', 'xinterio' ),
					'hover'		=> esc_attr__( 'Mouse-Over (Hover) Color', 'xinterio' ),
				),
				'default'	=> array(
					'normal'	=> '#403226',
					'hover'		=> '#bb9a65',
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preloader',
				'label'			=> esc_attr__( 'Show Preloader?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show or hide preloader', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'preloader-image',
				'label'			=> esc_html__( 'Select preloader image', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'   => get_template_directory_uri() . '/images/loader1.svg',
					'2'   => get_template_directory_uri() . '/images/loader2.svg',
					'3'   => get_template_directory_uri() . '/images/loader3.svg',
					'4'   => get_template_directory_uri() . '/images/loader4.svg',
					'5'   => get_template_directory_uri() . '/images/loader5.svg',
					'6'   => get_template_directory_uri() . '/images/loader6.svg',
					'7'   => get_template_directory_uri() . '/images/loader7.svg',
					'8'   => get_template_directory_uri() . '/images/loader8.svg',
					'9'   => get_template_directory_uri() . '/images/loader9.svg',
				),
				'active_callback'=> array( array(
					'setting' => 'preloader',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-page',
				'label'		=> esc_html__( 'Page Sidebar', 'xinterio' ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-advanced-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Advanced Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Special advanced options', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'body-bg-color',
				'label'			=> esc_attr__( 'Body Background Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This is default Body background color.', 'xinterio' ),
				'default'		=> '#ffffff',
			),
			array(
				'type'		=> 'switch',
				'settings'	=> 'min',
				'label'	   => esc_attr__( 'Load Minified CSS and JS Files?', 'xinterio' ),
				'description' => esc_attr__( 'Load minified files for CSS and JS code files. Select YES to reduce page load time.', 'xinterio' ),
				'default'	 => '1',
				'choices'	 => array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'hide_totop_button',
				'label'			=> esc_attr__( 'Hide Scroll to Top Button', 'xinterio' ),
				'description'	=> esc_attr__( 'Show or hide Scroll to Top ( Totop ) Button.', 'xinterio' ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'white-color',
				'label'			=> esc_attr__( 'White Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This is default white background color.', 'xinterio' ),
				'default'		=> '#ffffff',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'light-bg-color',
				'label'			=> esc_attr__( 'Light Background Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This is default grey background color.', 'xinterio' ),
				'default'		=> '#f6f6f6',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-color',
				'label'			=> esc_attr__( 'Blackish Text Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This is default blackish color for text.', 'xinterio' ),
				'default'		=> '#403226',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-bg-color',
				'label'			=> esc_attr__( 'Blackish Background Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This is default blackish background color.', 'xinterio' ),
				'default'		=> '#403226',
			),
			// Global image quality
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-image-qualityc-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Image quality Settings', 'xinterio' ) . '</h2></div>',
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'image-quality',
				'label'			=> esc_attr__( 'Image quality', 'xinterio' ),
				'description'	=> esc_attr__( 'Select image quality level. Default is "82%". This will effect JPG and JPEG images only.', 'xinterio' ),
				'default'		=> esc_attr('82'),
				'choices'		=>  array(
					'75'			=> esc_attr__( '75', 'xinterio' ),
					'80'			=> esc_attr__( '80', 'xinterio' ),
					'82'			=> esc_attr__( '82 (default)', 'xinterio' ),
					'85'			=> esc_attr__( '85', 'xinterio' ),
					'90'			=> esc_attr__( '90', 'xinterio' ),
					'95'			=> esc_attr__( '95', 'xinterio' ),
					'100'			=> esc_attr__( '100', 'xinterio' ),
				),
			),
		)
	),
	// Typography Settings
	'typography_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Typography Options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'typography',
				'settings'		=> 'global-typography',
				'label'			=> esc_attr__( 'Global Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array (
					'font-family'		=> 'Roboto',
					'variant'			=> '300',
					'font-size'			=> '16px',
					'line-height'		=> '1.6',
					'letter-spacing'	=> '0px',
					'color'				=> '#666666',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'			=> 10,
				'pbmit-output'		=> 'body',
				'pbmit-all-variants'	=> true,
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h1-typography',
				'label'			=> esc_attr__( 'H1 Typography', 'xinterio' ),
				'tooltip'	 => esc_attr__( 'This is tooltip', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '46px',
					'line-height'		=> '56px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h1',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h2-typography',
				'label'			=> esc_attr__( 'H2 Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '40px',
					'line-height'		=> '50px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h2',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h3-typography',
				'label'			=> esc_attr__( 'H3 Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '36px',
					'line-height'		=> '46px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h4-typography',
				'label'			=> esc_attr__( 'H4 Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '30px',
					'line-height'		=> '40px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h4',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h5-typography',
				'label'			=> esc_attr__( 'H5 Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '24px',
					'line-height'		=> '34px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h5',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h6-typography',
				'label'			=> esc_attr__( 'H6 Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '20px',
					'line-height'		=> '30px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'h6',
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Special Heading Typography', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Heading typography options', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'heading-typography',
				'label'			=> esc_attr__( 'Heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '48px',
					'line-height'		=> '48px',
					'letter-spacing'	=> '-2px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-heading-subheading .pbmit-element-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'subheading-typography',
				'label'			=> esc_attr__( 'Sub-heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> 'normal',
					'font-size'			=> '14px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '0px',
					'color'				=> '#bb9a65',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-heading-subheading .pbmit-element-subtitle,.pbmit-element-subtitle-new',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'content-typography',
				'label'			=> esc_attr__( 'Content Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Roboto',
					'variant'			=> '300',
					'font-size'			=> '16px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#666666',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-ihbox.pbmit-ihbox-style-hsbox .pbmit-ihbox-content',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'widget-heading-typography',
				'label'			=> esc_attr__( 'Widget Heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '24px',
					'line-height'		=> '30px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#403226',
					'text-transform'	=> 'capitalize',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '
				.pbminfotech-sidebar .widget_search .wp-block-search__label, .pbminfotech-sidebar .widget_block .wp-block-group h2, 
				.widget-title, .pbmit-footer-copyright-box h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'footer-widget-heading-typography',
				'label'			=> esc_attr__( 'Footer Widget Heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '18px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#bb9a65',
					'text-transform'	=> 'capitalize',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-footer-widget .widget .widget-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'buttons-typography',
				'label'			=> esc_attr__( 'Button Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '600',
					'font-size'			=> '16px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '-0.25px',
					'text-transform'	=> 'capitalize',
					'font-style'		=> 'normal',
				),
				'pbmit-output'	=> '.pbmit-search-results-back-global-btn a, .pbmit-search-results-load-btn a, .pbmit-read-more-link a, .pbmit-service-btn a, .woocommerce ul.products li.product .onsale, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .elementor-element .elementor-widget-button .elementor-button, .pbmit-ptable-btn, .pbmit-ptable-btn a, .pbmit-service-btn, .pbmit-ihbox-btn a, .woocommerce .woocommerce-message .button, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, button, html input[type=button], input[type=reset], input[type=submit], .pbmit-ads-button,.pbmit-ajax-load-more-btn a, .pbmit-header-button2 a,.pbmit-btn a .pbmit-button-text,.pbmit-form .wpcf7-submit, .pbmit-element-service-style-5 .pbmit-btn a, .pbmit-service-ads .pbmit-btn a, .woocommerce-cart .wc-block-grid__product-add-to-cart.wp-block-button .add_to_cart_button, .wc-block-components-button:not(.is-link),.wc-block-grid .wc-block-grid__products .wc-block-grid__product-onsale, .woocommerce span.onsale, .pbminfotech-ele-product-menu .pbmit-product-contents .price, .pbmit-header-button, .pbmit-static-btn a, .pbmit-portfolio-btn a',
			),
			// Extra Load Fonts Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'css-only-custom-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'CSS only Typography', 'xinterio' ) . '</h2> <span>' . esc_html__( 'This will not apply to any font style but this font will be loaded so we can use anywhere.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-1-typography',
				'label'			=> esc_attr__( 'First Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> 'normal',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'pbmit-output'	=> '.pbmit-service-style-3 .pbminfotech-box-number,.pbmit-ihbox-style-4 .pbmit-ihbox-icon:before, .pbmit-ele-blog .pbmit-meta-line,.pbmit-element-timeline-style-2 .pbmit-ourhistory-type2 .label,.pbmit-ihbox-style-10 .pbmit-element-title,.pbmit-comment-content .pbmit-comment-author .pbmit-comment-author-inner,.pbmit-comment-content .pbmit-comment-author,.single-post .pbmit-blog-list-ele li,.pbmit-blog-classic .pbmit-blog-meta span.pbmit-meta,.pbm_addons_recent_posts_widget .pbmit-rpw-content .pbmit-rpw-date a,.pbmit-ihbox-style-18 .pbmit-ihbox-box-number,.pbmit-testimonial-style-4 .pbminfotech-testimonial-text',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-2-typography',
				'label'			=> esc_attr__( 'Second Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '600',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'pbmit-output'	=> '.pbmit-ihbox-style-1 .pbmit-icon-type-icon, .pbmit-ihbox-style-1 .pbmit-ihbox-icon-type-text,.pbmit-ihbox-style-1 .pbmit-element-title,.pbminfotech-ele-fid-style-1 .pbmit-fid-inner,.pbminfotech-ele-fid-style-1 .pbmit-fid-sub .pbmit-fid-title,.pbminfotech-ele-ptable-style-1 .pbmit-ptable-price-w,.pbminfotech-ele-ptable-style-1 .pbminfotech-ptable-frequency,.pbminfotech-ele-ptable-style-1 .pbmit-pricing-table-featured-col .pbmit-feature-wrap .pbmit-ptablebox-featured-w,.pbmit-element-timeline-style-1 .pbmit-timeline-wrapper .pbmit-timeline-year,body .elementor-element .elementor-widget .elementor-icon-list-items .elementor-icon-list-text, .pbmit-tabs .pbmit-tab-list ul li,.site .elementor-element .elementor-accordion .elementor-tab-title .elementor-accordion-title,.pbminfotech-ele-fid-style-3 .pbmit-fid-inner,.site-content .pbmit_widget_list_all_posts ul>li a,.widget .download .item-download a,.pbm_addons_recent_posts_widget .pbmit-rpw-content .pbmit-rpw-title a,.site-content .widget.widget_categories ul li .pbmit-brackets,ul.wp-block-categories li .pbmit-cat-li a, ul.wp-block-archives li .pbmit-arc-li a, .site-content .widget.widget_categories ul li a, .site-content .widget.widget_archive ul li .pbmit-arc-li>a, .pbmit-portfolio-line-value,.post-navigation .nav-links .nav-title,.pbmit-author-content .pbmit-author-name,.reply a, .elementor-element .elementor-widget-progress .elementor-title,.site-content .widget_product_categories ul li a,.wc-block-components-totals-item__value,.woocommerce ul.order_details li strong,.pbmit-subheading-color .pbmit-heading-subheading h4.pbmit-element-subtitle,.pbmit-text-design,.pbmit-ihbox-style-11 .pbmit-ihbox-icon-type-text,.pbmit-ihbox-style-12 .pbmit-ihbox-icon-type-text,.pbmit-search-results-main-wrapper.skltbs-theme-light .skltbs-tab,.elementor-tabs .elementor-tabs-content-wrapper .pbmit-tab-list ul li,.elementor-widget-tabs .elementor-tab-desktop-title,.pbmit-ihbox-style-17 .pbmit-ihbox-icon-type-text, .pbmit-static-box-style-1 .pbmit-box-number, .pbmit-element-static-box-style-2 .pbmit-box-number, .pbmit-static-box-style-3 .pbmit-box-number, .pbmit-fid-style-6-new .pbminfotech-ele-fid-style-6 .pbmit-fid-title,.pbmit-tab-special .pbmit-tab-inner-content li',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-3-typography',
				'label'			=> esc_attr__( 'Third Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'pbmit-output'	=> '.pbmit-marquee-effect-style-1 .pbmit-tag-wrapper::before,.pbmit-tab-content-title, .pbmit-tab-link,.elementor-tabs .elementor-tabs-content-wrapper .pbmit-tab-number,.pbminfotech-ele-ptable-style-2 .pbminfotech-ptable-symbol,.pbminfotech-ele-ptable-style-2 .pbminfotech-ptable-price, .pbmit-progress-bar-style-1 .elementor-progress-percentage, .elementor-element .elementor-widget-heading .elementor-heading-title,.pbmit-element-static-box-style-4 .pbmit-box-number',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-4-typography',
				'label'			=> esc_attr__( 'Fourth Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 1000 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Roboto',
					'variant'			=> 'regular',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'pbmit-output'	=> '.comment-respond input[type="number"],.comment-respond input[type="text"],.comment-respond input[type="email"],.comment-respond input[type="password"],.comment-respond input[type="tel"],.comment-respond input[type="url"],.comment-respond input[type="search"],.comment-respond textarea,.pbmit-comment-content p,.pbmit-ihbox-style-23 .pbmit-element-title, .pbmit-ihbox-style-24 .pbmit-element-title',
			),
		)
	),
	// Pre-Header Options
	'preheader_options'	=> array(
		'section_settings'	=> array(
			'title'				=> esc_attr__( 'Pre-Header Options', 'xinterio' ),
			'panel'				=> 'xinterio_base_options',
			'priority'			=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-enable',
				'label'			=> esc_attr__( 'Show or hide Pre-header', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'			=> esc_attr__( 'Show', 'xinterio' ),
					'off'			=> esc_attr__( 'Hide', 'xinterio' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-text-color',
				'label'				=> esc_attr__( 'Select pre-header text color', 'xinterio' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'preheader-enable',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-bgcolor',
				'label'				=> esc_html__( 'Select pre-header background color', 'xinterio' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'preheader-bgcolor-custom',
				'label'			=> esc_attr__( 'Select pre-header background custom color', 'xinterio' ),
				'description'	=> esc_attr__( 'Select custom color for pre-header background', 'xinterio' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'preheader-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					),
					array(
						'setting'			=> 'preheader-enable',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'		  => 'number',
				'settings'	  => 'preheader-responsive',
				'label'		 => esc_attr__( 'Hide in screen size', 'xinterio' ),
				'description'   => esc_attr__( 'Select screen size to hide this pre-header below the selected screen size. Preferred Sizes: 1200, 1024, 992 and 768', 'xinterio' ),
				'default'	   => 1200,
				'choices'	   => array(
					'min'		   => 1,
					'max'		   => 2000,
					'step'		  => 1,
				),
				'active_callback'   => array( array(
					'setting'		   => 'preheader-enable',
					'operator'		  => '==',
					'value'			 => '1',
				) ),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'preheader-content-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Preheader content', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Manage preheader content from here', 'xinterio' ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-left',
				'label'			=> esc_attr__( 'Pre-header Left Content', 'xinterio' ),
				'default'		=> pbmit_esc_kses('[pbmit-social-links]'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-left'		=> array(
						'selector'			=> '.pbmit-pre-header-left',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-left');
						},
					)
				),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-right',
				'label'			=> esc_attr__( 'Pre-header Right Content', 'xinterio' ),
				'default'		=> pbmit_esc_kses('<ul class="pbmit-contact-info"><li><i class="pbmit-base-icon-mail-alt"></i> info@domain.com</li><li><i class=" pbmit-base-icon-location-dot-solid"></i>250 Main Street, 2nd Floor. USA</li><li><i class=" pbmit-base-icon-phone-volume-solid-1"></i>+89(0) 1256 2156</li></ul>'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-right'		=> array(
						'selector'			=> '.pbmit-pre-header-right',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-right');
						},
					)
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-search',
				'label'			=> esc_attr__( 'Show Search Icon in Pre-header Right Area?', 'xinterio' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in pre-header right side.', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
		),
	),

	// Header Options
	'header_options'	=> array(
		'section_settings'	=> array(
			'title'				=> esc_attr__( 'Header Options', 'xinterio' ),
			'panel'				=> 'xinterio_base_options',
			'priority'			=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'header-style',
				'label'			=> esc_html__( 'Header Style', 'xinterio' ),
				'description'	=> '<div class="pbmit-alert-message">'.esc_html__( 'NOTE: This will also change other options (like background color, menu color, logo etc) to set it with this header.', 'xinterio' ).'</div>',
				'default'		=> '1',
				'choices'		=> $header_style_array,
			),
			// Header button
			array(
				'type'				=> 'custom',
				'settings'			=> 'custom-header-button-options',
				'default'			=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Header Button', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'xinterio' ) . '</span></div>',
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text',
				'label'				=> esc_attr__( 'Header Button Text (1st line)', 'xinterio' ),
				'default'			=> esc_attr__( 'Call us Now', 'xinterio' ),
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn-text'	=> array(
						'selector'			=> '.pbmit-header-button',
						'render_callback'	=> function() {
							return pbmit_header_button( array('inneronly'=>'yes') );
						},
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text2',
				'label'				=> esc_attr__( 'Header Button Text (2nd line)', 'xinterio' ),
				'default'			=> esc_attr__( '+1(212)255-511', 'xinterio' ),
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '',
						),
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'xinterio' ),
				'default'			=> esc_url('tel:+1(212)-255-511'),
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
					)
				),
			),

			// Header Second button
			array(
				'type'				=> 'custom',
				'settings'			=> 'custom-header-button2-options',
				'default'			=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Header Button Second', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'xinterio' ) . '</span></div>',
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '6',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '7',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '10',
						),
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-text',
				'label'				=> esc_attr__( 'Header Button Text', 'xinterio' ),
				'default'			=> esc_attr__( 'Book Consult', 'xinterio' ),
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '6',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '7',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '10',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn2-text'	=> array(
						'selector'			=> '.pbmit-header-button2',
						'render_callback'	=> function() {
							return pbmit_header_button_second( array('inneronly'=>'yes') );
						},
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'xinterio' ),
				'default'			=> '',
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '6',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '7',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '8',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '9',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '10',
						),
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'General Options', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Common options that apply to all header styles', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'header-height',
				'label'			=> esc_attr__( 'Header Height (in pixel)', 'xinterio' ),
				'description'	=> esc_attr__( 'Select header height', 'xinterio' ),
				'default'		=> 85,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'xinterio' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'header-background-color',
				'label'			=> esc_attr__( 'Header Background Color', 'xinterio' ),
				'description'	=> esc_attr__( 'Select custom color for header background', 'xinterio' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Search in Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-search-header-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Search in Header', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Options for search in header area', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'header-search',
				'label'			=> esc_attr__( 'Show Search Icon in Header Area?', 'xinterio' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in header area.', 'xinterio' ),
				'default'		=> 0,
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			// Sticky Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-sticky-header-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sticky Header Options', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Options for sticky header area', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'sticky-header',
				'label'			=> esc_attr__( 'Sticky Header on Scroll?', 'xinterio' ),
				'description'	=> esc_attr__( 'Select YES to make header sticky on scroll.', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'sticky-header-mobile',
				'label'			=> esc_attr__( 'Show Sticky Header on Mobile', 'xinterio' ),
				'description'	=> esc_attr__( 'Select YES to show Sticky Header in Mobile.', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'			=> esc_attr__( 'Yes', 'xinterio' ),
					'off'			=> esc_attr__( 'No', 'xinterio' ),
				),
				'active_callback'	=> array(
					array(
						array(
							'setting'	=> 'sticky-header',
							'operator'	=> '==',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-header-height',
				'label'			=> esc_attr__( 'Sticky Area Height (in pixel)', 'xinterio' ),
				'description'	=> esc_attr__( 'Select Area height for sticky header', 'xinterio' ),
				'default'		=> 90,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 300,
					'step'			=> 1,
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'sticky-header',
							'operator'	=> '==',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'sticky-header-bgcolor',
				'label'				=> esc_html__( 'Sticky Area Background Color', 'xinterio' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'sticky-header-background-color',
				'label'			=> esc_attr__( 'Sticky Header Background Custom Color', 'xinterio' ),
				'description'	=> esc_attr__( 'Select custom color for sticky header background', 'xinterio' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						'setting'	=> 'sticky-header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Responsive Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'responsive-header-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Responsive Header Options', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Options for responsive (mobile or tablet mode) header area', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'responsive-header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'xinterio' ),
				'default'			=> '',
				'choices'			=> $pre_two_color_list,
			),
		),
	),
	// Menu Options
	'menu_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Menu Options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Main Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'main-menu-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Main Menu Options', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Set Main Menu font settings', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'main-menu-typography',
				'label'			=> esc_attr__( 'Main Menu Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '600',
					'font-size'			=> '16px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '0px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> 'body:not(.mega-menu-pbminfotech-top) .pbmit-navbar div > ul > li > a, .pbmit-max-mega-menu-override #page #site-navigation .max-mega-menu > li.mega-menu-item > a.mega-menu-link, .pbmit-burger-menu-area .menu-main-menu-container ul > li > a',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'main-menu-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color', 'xinterio' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active', 'xinterio' ),
				'default'		=> 'globalcolor',
				'choices'		=> $pre_text_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-color',
				'label'			=> esc_attr__( 'Main Menu Text Color for Sticky Header', 'xinterio' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu text when header is sticky', 'xinterio' ),
				'default'		=> '#403226',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color for Sticky Header', 'xinterio' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active in sticky header', 'xinterio' ),
				'default'		=> '#bb9a65',
			),
			// Dropdown Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'drop-down-menu-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Dropdown Menu Options', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Set Dropdown font settings', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'dropdown-menu-typography',
				'label'			=> esc_attr__( 'Dropdown Menu Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '600',
					'font-size'			=> '14px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '0px',
					'color'				=> '#403226',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-navbar ul ul a, 
				.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
				.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:hover, 
				.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:focus,
				.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu ul:not(.menu) > li.mega-menu-item > a.mega-menu-link,
				.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li .widget_nav_menu ul.menu > li.mega-menu-item > a.mega-menu-link, .pbmit-burger-menu-area .menu-main-menu-container ul ul a',
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'dropdown_background',
				'label'			=> esc_attr__( 'Dropdown Menu Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for Dropdown Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu,.pbmit-navbar ul ul, .pbmit-navbar ul ul:before,.pbmit-navbar ul.sub-menu:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'drop-down-menu-active-color',
				'label'				=> esc_html__( 'Dropdown Menu Active Color', 'xinterio' ),
				'default'			=> 'globalcolor',
				'choices'			=> $pre_text_color_list,
			),
			// Max Mega Menu Option
			array(
				'type'			=> 'custom',
				'settings'		=> 'max-mega-menu-override-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Max Mega Menu Plugin Option', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Option for Max Mega Menu plugin', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'max-mega-menu-override',
				'label'			=> esc_attr__( 'Override Max Mega Menu design?', 'xinterio' ),
				'description'	=> esc_attr__( 'Select YES to override Max Mega Menu design. Make sure you are using "Max Mega Menu" plugin for mega menu', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'mmm-title-typography',
				'label'			=> esc_attr__( 'Max Mega Menu - Widget Title Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Signika',
					'variant'			=> '500',
					'font-size'			=> '18px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '0px',
					'color'				=> '#5b8c51',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title, .pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title',
			),
			array( // 1st dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-1-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 1st Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for first Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(1) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(1) > ul.mega-sub-menu:before',
			),
			array( // 2nd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-2-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 2nd Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for second Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(2) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(2) > ul.mega-sub-menu:before',
			),
			array( // 3rd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-3-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 3rd Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for third Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(3) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(3) > ul.mega-sub-menu:before',
			),
			array( // 4th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-4-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 4th Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for fourth Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(4) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(4) > ul.mega-sub-menu:before',
			),
			array( // 5th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-5-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 5th Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for fifth Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(5) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(5) > ul.mega-sub-menu:before',
			),
			array( // 6th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-6-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 6th Dropdown Menu Background Option', 'xinterio' ),
				'description'	=> esc_attr__( 'Background settings for sixth Dropdown Menu in Max Mega Menu', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(6) > ul.mega-sub-menu,.pbmit-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(6) > ul.mega-sub-menu:before',
			),
		)
	),
	// Titlebar Options
	'titlebar_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Titlebar Options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-enable',
				'label'			=> esc_attr__( 'Show Titlebar?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show or hide Titlebar', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'titlebar-height',
				'label'			=> esc_attr__( 'Titlebar Height', 'xinterio' ),
				'default'		=> 300,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'titlebar-style',
				'label'			=> esc_attr__( 'Titlebar Style', 'xinterio' ),
				'description'	=> esc_attr__( 'Select style for Titlebar', 'xinterio' ),
				'default'		=> 'left',
				'choices'		=>  array(
					'left'			=> esc_attr__( 'All Left Aligned', 'xinterio' ),
					'center'		=> esc_attr__( 'All Center Aligned', 'xinterio' )
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-hide-breadcrumb',
				'label'			=> esc_attr__( 'Hide Breadcrumb?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show or hide breadcrumb in Titlebar', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'multicheck',
				'settings'		=> 'titlebar-bg-featured',
				'label'			=> esc_attr__( 'Featured Image as Titlebar Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Select which section (CPT) will show featured image as background image in Titlebar. NOTE: This will work for Single view only.', 'xinterio' ),
				'default'		=> array(),
				'choices'		=> array(
					'post'				=> sprintf( esc_attr__('For %1$s', 'xinterio') , '"Post"' ),
					'page'				=> sprintf( esc_attr__('For %1$s', 'xinterio') , '"Page"' ),
					'pbmit-portfolio'	=> sprintf( esc_attr__('For %1$s', 'xinterio') , '"'.$portfolio_cpt_singular_title.'"' ),
					'pbmit-team-member'	=> sprintf( esc_attr__('For %1$s', 'xinterio') , '"'.$team_cpt_singular_title.'"' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'titlebar-bgcolor',
				'label'				=> esc_html__( 'Select Titlebar background color', 'xinterio' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_color_with_gradient_list,
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'titlebar-background',
				'label'			=> esc_attr__( 'Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Background Settings', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> 'rgba(0,0,0,0.2)',
					'background-repeat'		=> 'no-repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'pbmit-output'	=> '.pbmit-title-bar-wrapper, .pbmit-title-bar-wrapper.pbmit-bg-color-custom:before',
				'active_callback' => array( array(
					'setting'		=> 'titlebar-enable',
					'operator'		=> '==',
					'value'			=> '1',
				) ),
			),
			array(
				'type'		=> 'typography',
				'settings'	=> 'titlebar-heading-typography',
				'label'		=> esc_attr__( 'Titlebar Heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '700',
					'font-size'			=> '60px',
					'line-height'		=> '60px',
					'letter-spacing'	=> '-0.25px',
					'color'				=> '#ffffff',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-tbar-title',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-subheading-typography',
				'label'			=> esc_attr__( 'Titlebar Sub-heading Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Space Grotesk',
					'variant'			=> '600',
					'font-size'			=> '16px',
					'line-height'		=> '24px',
					'letter-spacing'	=> '0px',
					'color'				=> '#ffffff',
					'text-transform'	=> 'capitalize',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'pbmit-output'	=> '.pbmit-tbar-subtitle',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-breadcrumb-typography',
				'label'			=> esc_attr__( 'Titlebar Breadcrumb Typography', 'xinterio' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Roboto',
					'variant'			=> '300',
					'font-size'			=> '15px',
					'line-height'		=> '25px',
					'letter-spacing'	=> '0.5',
					'color'				=> '#ffffff',
					'text-transform'	=> 'capitalize',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
			'priority'				=> 10,
				'pbmit-output'		=> '.pbmit-breadcrumb, .pbmit-breadcrumb a',
				'active_callback'	=> array(
					array(
						'setting'			=> 'titlebar-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'titlebar-hide-breadcrumb',
						'operator'			=> '==',
						'value'				=> '0',
					)
				),
			),
		),
	),
	// Footer Options
		'footer_options' => array(
			'section_settings' => array(
				'title'			=> esc_attr__( 'Footer Options', 'xinterio' ),
				'panel'			=> 'xinterio_base_options',
				'priority'		=> 160,
			),
			'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-enable',
				'label'			=> esc_attr__( 'Show footer?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show or hide footer', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			// Footer Background settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-background-settings-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Footer Background Settings', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Manage footer background settings from here', 'xinterio' ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-style',
				'label'			=> esc_html__( 'Select Footer Style', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'				=> get_template_directory_uri() . '/includes/images/footer-style-1.jpg',
					'2'				=> get_template_directory_uri() . '/includes/images/footer-style-2.jpg',
					'3'				=> get_template_directory_uri() . '/includes/images/footer-style-3.jpg',
					'4'				=> get_template_directory_uri() . '/includes/images/footer-style-4.jpg',
				),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-bgcolor',
				'label'			=> esc_html__( 'Select Full Footer background color', 'xinterio' ),
				'description'	=> esc_attr__( 'This will be applied to full footer area including footer widget area and footer copyright area.', 'xinterio' ),
				'default'		=> 'light-bg',
				'choices'		=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-background',
				'label'			=> esc_attr__( 'Full Footer Background', 'xinterio' ),
				'description'	=> esc_attr__( 'This will be applied to full footer area including footer widget area and footer copyright area.', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#f6f6f6',
					'background-image'		=> '',
					'background-repeat'		=> 'no-repeat',
					'background-position'	=> 'center top',
					'background-size'		=> 'contain',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'pbmit-output'	=> '.site-footer, .site-footer.pbmit-bg-color-custom:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-text-color',
				'label'				=> esc_attr__( 'Select Footer Text Color', 'xinterio' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			// Footer Boxes Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-boxes-area-heading',
				'default'		=> '<div class="xinterio-option-heading"><h2>' . esc_html__( 'Footer Boxes Area', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Manage footer boxes from here', 'xinterio' ) . '</span></div>',
				'active_callback'=> array(	
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),	
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '2',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '4',
						),
					),
				),
			),

			// Show Footer Boxes
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-boxes-area',
				'label'			=> esc_attr__( 'Show footer boxes?', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
				'active_callback'=> array(	
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '2',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '4',
						),
					),
				),
			),

			array(
				'type'			=> 'textarea',
				'settings'		=> 'footer-left-area',
				'label'			=> esc_attr__( 'Footer Left Area', 'xinterio' ),
				'default'		=> pbmit_esc_kses('<span class="pbmit-email-text"> hello@example.com</span><span class="pbmit-phone-number"> +79 2589 63598</span>'),
				'active_callback'=> array(
					array(
					'setting'	=> 'footer-boxes-area',
					'operator' 	=> '==',
					'value' 		=> '1',
					),
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '2',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
					),
				),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'footer-right-area',
				'label'			=> esc_attr__( 'Footer Right Area', 'xinterio' ),
				'default'		=> pbmit_esc_kses('<span class="pbmit-address"> Chicago HQ Estica cop, <br>Macomb,MI 48042</span>'),
				'active_callback'=> array(
					array(
					'setting'	=> 'footer-boxes-area',
					'operator' 	=> '==',
					'value' 		=> '1',
					),
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '4',
						),
					),
				),
			),

			array(
				'type'			=> 'textarea',
				'settings'		=> 'footer-right-social-area',
				'label'			=> esc_attr__( 'Footer Right Social Area', 'xinterio' ),
				'default'		=> pbmit_esc_kses('[pbmit-social-links]'),
				'active_callback'=> array(
					array(
					'setting'	=> 'footer-boxes-area',
					'operator' 	=> '==',
					'value' 		=> '1',
					),
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
					),
				),
			),


			array(
				'type'				=> 'image',
				'settings'			=> 'footer-right-image',
				'label'				=> esc_attr__( 'Foorer Right Image', 'xinterio' ),
				'default'			=> get_template_directory_uri() . '/images/footer-mailchip-img.png',
				'active_callback'=> array(
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						'setting'	=> 'footer-boxes-area',
						'operator' 	=> '==',
						'value' 		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '2',
						),
					),
				),
			),

			// Footer Instagram Boxes Area
			array(
				'type'				=> 'custom',
				'settings'			=> 'footer-Instagram-area-heading',
				'label'				=> '<div class="xinterio-option-heading"><h2>' . esc_html__( 'Footer Instagram Area', 'xinterio' ) . '</h2></div>',
				'active_callback'	=> array(
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
					),
				),
			),

			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-instagram-area',
				'description'	=> esc_attr__( 'Show Instagram images? (make sure you installed instagram plugin)', 'xinterio' ) . ' ' . pbmit_esc_kses('<br><a target="_blank" href="' . esc_url('https://wordpress.org/plugins/instagram-feed/') . '">' . esc_attr__( 'Instagram Feed.', 'xinterio' ) . '</a>' ),
				'label'			=> esc_attr__( 'Show footer instagram?', 'xinterio' ),
				'default'		=> 'off',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
				'active_callback'=> array(	
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
					),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'footer-instagram-text',
				'description'	=> esc_attr__( 'You can use [instagram-feed feed=1] shortcode for Show instagram Post.', 'xinterio' ),
				'active_callback'=> array(
					array(
						'setting'	=> 'footer-instagram-area',
						'operator'	=> '==',
						'value' 	=> '1',
					),
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
					),
				),
			),

			array(
				'type'				=> 'image',
				'settings'			=> 'footer-logo',
				'label'				=> esc_attr__( 'Foorer Logo', 'xinterio' ),
				'default'			=> get_template_directory_uri() . '/images/logo.svg',
				'active_callback'=> array(
					array(
						'setting'	=> 'footer-enable',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '2',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator' 	=> '==',
							'value' 	=> '4',
						),
					),
				),
			),
			// Footer Widget Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-widget-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Footer Widget Area', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Manage widget area settings', 'xinterio' ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'footer-column',
				'label'		=> esc_html__( 'Footer Widget Column Type', 'xinterio' ),
				'description'	=> esc_html__( 'This will show widgets. You can manage it from "Admin > Appearance > Widgets" section.', 'xinterio' ),
				'default'	=> '4-4-4',
				'choices'		=> array(
					'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
					'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
					'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
					'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
					'2-2-2-6'	=> get_template_directory_uri() . '/includes/images/footer-2-2-2-6.png',
					'6-2-2-2'	=> get_template_directory_uri() . '/includes/images/footer-6-2-2-2.png',
					'8-4'		=> get_template_directory_uri() . '/includes/images/footer-8-4.png',
					'4-8'		=> get_template_directory_uri() . '/includes/images/footer-4-8.png',
					'custom'	=> get_template_directory_uri() . '/includes/images/footer-col-custom.png',
				),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-1-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 1st Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Set custom width of the 1st column in footer widget area', 'xinterio' ),
				'default'		=> '33',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-2-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 2nd Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Set custom width of the 2nd column in footer widget area', 'xinterio' ),
				'default'		=> '34',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-3-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 3rd Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Set custom width of the 3rd column in footer widget area', 'xinterio' ),
				'default'		=> '34',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-4-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 4th Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Set custom width of the 4th column in footer widget area', 'xinterio' ),
				'default'		=> 'hide',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),

			// Footer Copyright Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-copyright-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Footer Copyright Text Area', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Manage bottom footer area from here', 'xinterio' ) . '</span></div>',
			),

			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-bgcolor',
				'label'				=> esc_html__( 'Select Footer Copyright Area background color', 'xinterio' ),
				'default'			=> 'transparent',
				'choices'			=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
				'active_callback'	=> array(
					array(
						'setting'		=> 'footer-enable',
						'operator'		=> '==',
						'value'			=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					),
				),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-copyright-background',
				'label'			=> esc_attr__( 'Footer Copyright Area Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Background Settings for footer copyright area', 'xinterio' ),
				'default'		=> array(
					'background-color'		=> '#f6f6f6',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'	=> array(
					array(
						'setting'		=> 'footer-enable',
						'operator'		=> '==',
						'value'			=> '1',
					),
					array(
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					),
				),
				'pbmit-output'	=> '.pbmit-footer-text-area, .pbmit-footer-text-area.pbmit-bg-color-custom::before, .pbmit-footer-style-4 .pbmit-footer-text-area .pbmit-footer-text-inner, .pbmit-footer-style-4 .pbmit-footer-text-area.pbmit-bg-color-custom .pbmit-footer-text-inner',
			),
			array(
				'type'			=> 'editor',
				'settings'		=> 'copyright-text',
				'label'			=> esc_attr__( 'Footer Copyright Text', 'xinterio' ),
				'default'		=> sprintf( esc_attr__( 'Copyright &copy; %1$s %2$s, All Rights Reserved.', 'xinterio' ), date('Y'), '<a href="' . esc_url( home_url( '/' ) ) . '">' . get_bloginfo('name') . '</a>' ),
				'priority'		=> 10,
				'partial_refresh'	=> array(
					'copyright-text'		=> array(
						'selector'			=> '.pbmit-footer-copyright-text',
						'render_callback'	=> function() {
							return get_theme_mod('copyright-text');
						},
					)
				),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-copyright-right-content',
				'label'			=> esc_attr__( 'Footer Right Area', 'xinterio' ),
				'description'	=> esc_attr__( 'What you like to show at right side or copyright text', 'xinterio' ),
				'default'		=> 'menu',
				'choices'		=> array(
					'social'		=> esc_attr__( 'Show Social Links', 'xinterio' ),
					'menu'			=> esc_attr__( 'Show Footer Menu', 'xinterio' ),
					'none'			=> esc_attr__( 'None', 'xinterio' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),	
			),
		)
	),
	// Social Links Options
	'social_links_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Social Links Options', 'xinterio' ),
			'description'	=> esc_attr__( 'You can use [pbmit-social-links] shortcode for social list with icon.', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => $social_options_array
	),
	// Blog Settings
	'blog_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Blog Options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Blog Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Settings for Blogroll, Category, Tag, Archives etc section.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'radio',
				'settings'		=> 'blogroll-view-select',
				'label'			=> esc_html__( 'Select Blogroll view', 'xinterio' ),
				'default'		=> 'classic',
				'choices'	 	=> [
					'classic'   	=> esc_html__( 'Classic View', 'xinterio' ),
					'grid' 			=> esc_html__( 'Grid View', 'xinterio' ),
				],
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-view',
				'label'			=> esc_html__( 'Blogroll view', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> pbmit_element_template_list('blog', 'customizer'),
				'active_callback'	=> array(
					array(
						'setting'		=> 'blogroll-view-select',
						'operator'		=> '==',
						'value'			=> 'grid',
					)
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-column',
				'label'			=> esc_html__( 'Blogroll column', 'xinterio' ),
				'default'		=> '2',
				'choices'		=> $column_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'blogroll-view-select',
						'operator'		=> '==',
						'value'			=> 'grid',
					)
				),
			),
			array(
			'type'			=> 'switch',
			'settings'		=> 'blog-show-related',
			'label'			=> esc_attr__( 'Show Related Post?', 'xinterio' ),
			'default'		=> '0',
			'choices'	 => array(
				'on'  => esc_attr__( 'Yes', 'xinterio' ),
				'off' => esc_attr__( 'No', 'xinterio' ),
			),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'blog-related-title',
				'label'			=> esc_attr__( 'Related Post Section Title', 'xinterio' ), 
				'description'	=> esc_attr__( 'Related Area Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Related Post', 'xinterio' ),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-related-count',
				'label'			=> esc_attr__( 'How many post you like to show', 'xinterio' ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-column',
				'label'			=>  esc_html__('Related Post Column', 'xinterio' ),
				'default'		=> '2',
				'choices'	 => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-style',
				'label'			=> esc_html__( 'Related Post View', 'xinterio' ),
				'default'		=> '1',
				'choices'	 => $blog_styles,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-classic-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Blog Classic Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Classic view.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-classic-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Classic view?', 'xinterio' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-classic-limit',
				'label'			=> esc_attr__( 'Set Word Limit for Blog Classic view', 'xinterio' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link. This is useful if you didn\'t added Read More link in posts.', 'xinterio' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-classic-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-element-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Blog Style Elements (boxes) Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Style Elements.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-element-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Element view?', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-element-limit',
				'label'			=> esc_attr__( 'Limit Words for Blog Element view', 'xinterio' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link.', 'xinterio' ),
				'default'		=> 15,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-element-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-sidebar-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Select sidebar position Page and Blog section.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-post',
				'label'		=> esc_html__( 'Blog Sidebar', 'xinterio' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Portfolio Settings
	'portfolio_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'xinterio' ) , $portfolio_cpt_singular_title ) ,
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'xinterio' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Options for Single %1$s Section', 'xinterio' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'portfolio-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $portfolio_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-detailsbox-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Details Box Options', 'xinterio' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . esc_attr__( 'Details Box Settings', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-details-title',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box Title', 'xinterio' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Details Box Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Project info', 'xinterio' ),
			),
			array(
				'type'			=> 'repeater',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box', 'xinterio' ), $portfolio_cpt_singular_title ),
				'row_label'		=> array(
					'type'			=> 'field',
					'value'			=> esc_attr__('Line', 'xinterio' ),
					'field'			=> 'line_title',
				),
				'button_label'	=> esc_attr__('Add New Line', 'xinterio' ),
				'settings'		=> 'portfolio-details',
				'fields'		=> array(
					'line_title'	=> array(
						'type'			=> 'text',
						'label'			=> esc_attr__( 'Line Title', 'xinterio' ),
						'description'	=> esc_attr__( 'This will be the label for the line', 'xinterio' ),
						'default'		=> '',
					),
					'line_type'		=> array(
						'type'			=> 'select',
						'label'			=> esc_attr__( 'Line Type', 'xinterio' ),
						'description'	=> esc_attr__( 'This will be type for the line', 'xinterio' ),
						'default'		=> 'text',
						'choices'		=> array(
							'text'			=> esc_attr__( 'Normal Text', 'xinterio' ),
							'category'		=> esc_attr__( 'Category List (without link)', 'xinterio' ),
							'category-link'	=> esc_attr__( 'Category List (with link)', 'xinterio' ),
						)
					),
				),
				'default'		=> array(
					array(
						'line_title'	=> esc_attr__('Architect', 'xinterio'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Client', 'xinterio'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Terms', 'xinterio'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Project Type', 'xinterio'),
						'line_type'		=> 'category',
					),
					array(
						'line_title'	=> esc_attr__('Strategy', 'xinterio'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Date', 'xinterio'),
						'line_type'		=> 'text',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-related-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Related %1$s Options', 'xinterio' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_html__( 'Options for Related %1$s', 'xinterio' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'portfolio-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s?', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-related-title',
				'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'xinterio' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Related Area Title', 'xinterio' ),
				'default'		=> sprintf( esc_attr__( 'Related %1$s', 'xinterio' ), $portfolio_cpt_singular_title ),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'		=> '1',
				'choices'		=> pbmit_element_template_list('portfolio', 'customizer'),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-cat-view',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'xinterio' ), $portfolio_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'xinterio' ) , $portfolio_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'xinterio' ), $portfolio_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> pbmit_element_template_list('portfolio', 'customizer'),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'xinterio' ), $portfolio_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'xinterio' ), $portfolio_cpt_singular_title, $portfolio_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-sidebar-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'xinterio' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $portfolio_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $portfolio_cat_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'portfolio-advanced-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Advanced Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'xinterio' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'xinterio' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Portfolio', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'xinterio' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Portfolio', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'xinterio' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'portfolio' ),
				'priority'		=> 10,
			),
			// Portfolio Category
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'xinterio' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Portfolio Categories', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'xinterio' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Portfolio Category', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'xinterio' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug', 'xinterio' ),
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'priority'		=> 10,
			),
		)
	),
	// Service Settings
	'service_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'xinterio' ) , $service_cpt_singular_title ) ,
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-service-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'xinterio' ), $service_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'xinterio' ), $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'service-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'xinterio' ), $service_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $service_single_style_array,
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s', 'xinterio' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'	 => array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-related-title',
				'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'xinterio' ), $service_cpt_singular_title ),
				'description'	=> esc_attr__( 'Related Area Title', 'xinterio' ),
				'default'		=> sprintf( esc_attr__( 'Related %1$s', 'xinterio' ), $service_cpt_singular_title ),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'xinterio' ), $service_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'xinterio' ), $service_cpt_singular_title ),
				'default'		=> '3',
				'choices'	 => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'xinterio' ), $service_cpt_singular_title ),
				'default'		=> '1',
				'choices'	 => pbmit_element_template_list('service', 'customizer'),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-cat-view',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'xinterio' ), $service_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'xinterio' ) , $service_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'xinterio' ), $service_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> pbmit_element_template_list('service', 'customizer'),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'xinterio' ), $service_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'xinterio' ), $service_cpt_singular_title, $service_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-sidebar-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'xinterio' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $service_cpt_singular_title ),
				'default'	=> 'left',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $service_cat_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced - Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'service-advanced-heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Advanced Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'xinterio' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(	
				'type'			=> 'text',
				'settings'		=> 'service-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'xinterio' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Service', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'xinterio' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Service', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'xinterio' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service' ),
				'priority'		=> 10,
			),
			// Service Category
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'xinterio' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Service Categories', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'xinterio' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Service Category', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'xinterio' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service-category' ),
				'priority'		=> 10,
			),
		)
	),
	// Team Member Settings
	'team_options' => array(
			'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'xinterio' ) , $team_cpt_singular_title ) ,
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-team-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'xinterio' ), $team_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'xinterio' ), $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'team-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'xinterio' ), $team_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $team_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-group-view',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'xinterio' ), $team_group_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'xinterio' ) , $team_group_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'xinterio' ), $team_group_singular_title ),
				'default'		=> '1',
				'choices'		=> pbmit_element_template_list('team', 'customizer'),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'xinterio' ), $team_group_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'team-group-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'xinterio' ), $team_cpt_singular_title, $team_group_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-member-sidebar-settings',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'xinterio' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-member',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $team_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-group',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'xinterio' ), $team_group_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'team_advanced_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Advanced Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'xinterio' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'xinterio' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Team Members', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'xinterio' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Team Member', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'xinterio' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team' ),
				'priority'		=> 10,
			),
			// Team Member group
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'xinterio' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Team Groups', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'xinterio' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Team Group', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'xinterio' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'xinterio' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'xinterio' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'xinterio' ), pbmit_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team-group' ),
				'priority'		=> 10,
			),
		)
	),
	// Testimonial Settings
	'testimonial_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'xinterio' ) , $testimonial_cpt_singular_title ) ,
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'testimonial_advanced_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Advanced Options', 'xinterio' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'xinterio' ) , $testimonial_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'xinterio' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Testimonials', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'xinterio' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Testimonial', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'xinterio' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Testimonial Categories', 'xinterio' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'xinterio' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'xinterio' ),
				'default'		=> esc_attr__( 'Testimonial Category', 'xinterio' ),
				'priority'		=> 10,
			),
		)
	),
	// Search Settings
	'search_results_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Search Results options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'search_results_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Search Results Settings', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Settings for Search Results page', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'no-results-title',
				'label'			=> esc_attr__( 'Title for "No Search Results" page', 'xinterio' ),
				'description'	=> esc_attr__( 'Title to show when there is no search results', 'xinterio' ),
				'default'		=> esc_attr__( 'No Results Found', 'xinterio' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'no-results-text',
				'label'			=> esc_attr__( 'Text for "No Search Results" page', 'xinterio' ),
				'description'	=> esc_attr__( 'Text to show when there is no search results', 'xinterio' ),
				'default'		=> esc_attr__('Sorry, but nothing matched your search terms. Please try again with some different keywords.','xinterio'),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'search-sidebar-options',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for search results page.', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-search',
				'label'		=> esc_html__( 'Search Results Sidebar', 'xinterio' ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Error 404 Settings
	'error_404_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Error 404 options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Error 404 Settings', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Settings for error 404 page', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'error-404-heading',
				'label'			=> esc_attr__( 'Error 404 Heading', 'xinterio' ),
				'description'	=> esc_attr__( 'This is heading for 404 page', 'xinterio' ),
				'default'		=> esc_attr__( '404', 'xinterio' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'error-404-text',
				'label'			=> esc_attr__( 'Error 404 Text', 'xinterio' ),
				'description'	=> esc_attr__( 'This is text for 404 page', 'xinterio' ),
				'default'		=> esc_attr__( 'Whoops! Whatever you are looking for cannot be found.', 'xinterio' ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'error-404-show-search',
				'label'			=> esc_attr__( 'Show search form on 404 page', 'xinterio' ),
				'default'		=> '1',
				'priority'		=> 10,
				'choices'		=> array(
					'on'			=> esc_attr__( 'Yes', 'xinterio' ),
					'off'			=> esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_text_custom',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Error 404 Text Color', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Settings for text color for 404 error page', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-text-color',
				'label'				=> esc_attr__( 'Select 404 page text color', 'xinterio' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_2_list,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_bg_custom',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Error 404 Background Option', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Settings for background color/image for 404 error page', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-bgcolor',
				'label'				=> esc_html__( 'Select 404 page background color', 'xinterio' ),
				'default'			=> 'custom',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'e404-background',
				'label'			=> esc_attr__( 'Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Background Settings', 'xinterio' ),
				'default'		=> array(				
					'background-color'	  => 'rgba(0,0,0,0.37)',
					'background-repeat'	 => 'no-repeat',
					'background-position'   => 'center center',
					'background-size'	   => 'cover',
					'background-attachment' => 'scroll',
				),
				'pbmit-output'	=> '.error404 .site-content-wrap, .error404 .pbmit-bg-color-custom > .site-content-wrap:before',
			),
		)
	),
	// Login Page Settings
	'login_page_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Login Page options', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'login_page_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Login Page Settings', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Settings for Login Page page', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'custom-login-logo',
				'label'			=> esc_attr__( 'Show different logo?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show different logo then the default logo you selected for your site.', 'xinterio' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'xinterio' ),
					'off' => esc_attr__( 'No', 'xinterio' ),
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'login-logo',
				'label'				=> esc_attr__( 'Login Page Custom Logo', 'xinterio' ),
				'description'		=> esc_attr__( 'Select logo for the login page', 'xinterio' ),
				'default'			=> get_template_directory_uri() . '/images/logo.svg',
				'active_callback'	=> array( array(
					'setting'			=> 'custom-login-logo',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'login-page-background',
				'label'			=> esc_attr__( 'Login Page Background', 'xinterio' ),
				'description'	=> esc_attr__( 'Background Settings for the login page', 'xinterio' ),
				'default'		=> array(				
					'background-color'	  => '#666666',
					'background-repeat'	 => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'	   => 'cover',
					'background-attachment' => 'scroll',
				),
			),
		)
	),
	// Custom CSS/JS Options
	'custom_code_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'CSS/JS Code', 'xinterio' ),
			'panel'			=> 'xinterio_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'tracking_js_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Tracking Code', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Code for Google Tracking or other ', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'tracking-code',
				'label'			=> esc_attr__( 'Tracking Code', 'xinterio' ),
				'description'	=> esc_attr__( 'This code will be added to HEAD element on your all pages.', 'xinterio' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'cust_css_heading',
				'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Custom CSS Code', 'xinterio' ) . '</h2> <span>' . esc_attr__( 'Custom CSS Code', 'xinterio' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'css-code',
				'label'			=> esc_attr__( 'Custom CSS Code', 'xinterio' ),
				'description'	=> esc_attr__( 'Add your custom CSS code here.', 'xinterio' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'js-code',
				'label'			=> esc_attr__( 'Custom JS Code', 'xinterio' ),
				'description'	=> esc_attr__( 'Add your custom JS code here.', 'xinterio' ),
				'default'		=> '',
			),
		)
	),
);
// adding WooCommerce options
if( function_exists('is_woocommerce') ){
	$kirki_options_array2 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array2[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array2['woocommerce_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'WooCommerce Options', 'xinterio' ),
					'panel'			=> 'xinterio_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-shop',
						'label'		=> esc_html__( 'WooCommerce Shop Sidebar', 'xinterio' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-single',
						'label'		=> esc_html__( 'WooCommerce Single Product Sidebar', 'xinterio' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'text',
						'settings'	=> 'wc-title',
						'label'		=> esc_attr__( 'WooCommerce Shop Page Title', 'xinterio' ),
						'description'	=> esc_attr__( 'This will appear in Titlebar on Shop page.', 'xinterio' ),
						'default'	=> esc_attr('Shop'),
					),
					array(
						'type'			=> 'select',
						'settings'		=> 'wc-related-count',
						'label'			=> esc_attr__( 'How many related products will be shown?', 'xinterio' ),
						'description'	=> esc_attr__( 'How many related products will be shown on single product page?', 'xinterio' ),
						'default'		=> '3',
						'choices'		=> array(
							'1'		=> esc_attr__( '1 product', 'xinterio' ),
							'2'		=> esc_attr__( '2 products', 'xinterio' ),
							'3'		=> esc_attr__( '3 products', 'xinterio' ),
							'4'		=> esc_attr__( '4 products', 'xinterio' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-icon',
						'label'			=> esc_attr__( 'Show Cart Icon in Header?', 'xinterio' ),
						'description'	=> esc_attr__( 'Show or hide cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'xinterio' ),
						'default'		=> '0',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'xinterio' ),
							'off'		=> esc_attr__( 'No', 'xinterio' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-amount',
						'label'			=> esc_attr__( 'Show Amount with Cart Icon in Header?', 'xinterio' ),
						'description'	=> esc_attr__( 'Show or hide cart amount with cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'xinterio' ),
						'default'		=> '0',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'xinterio' ),
							'off'		=> esc_attr__( 'No', 'xinterio' ),
						),
						'active_callback' => array( array(
							'setting'		=> 'wc-show-cart-icon',
							'operator'		=> '==',
							'value'			=> '1',
						) ),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array2;
}
// adding Event options
if( class_exists('WP_Event_Manager') ){
	$kirki_options_array3 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array3[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array3['event_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'Event Options', 'xinterio' ),
					'panel'			=> 'xinterio_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'			=> 'custom',
						'settings'		=> 'custom-event-column-options',
						'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Column Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Select column for the Event listing.', 'xinterio' ) . '</span></div>',
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'event-column',
						'label'		=> esc_html__( 'Event Column', 'xinterio' ),
						'description'	=> esc_html__( 'Select column structure for Event', 'xinterio' ),
						'default'	=> '3-3-3-3',
						'choices'		=> array(
							'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
							'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
							'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
							'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
						),
					),
					// Heading Options
					array(
						'type'			=> 'custom',
						'settings'		=> 'custom-event-sidebar-options',
						'default'		=> '<div class="pbminfotech-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'xinterio' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for Event section.', 'xinterio' ) . '</span></div>',
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-event',
						'label'		=> esc_html__( 'Event Sidebar', 'xinterio' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-event-single',
						'label'		=> esc_html__( 'Event Single Sidebar', 'xinterio' ),
						'default'	=> 'no',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array3;
}