<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)
/**
 * Widget Name: Projects Carousel
 */
class PBMIT_PTableElement extends Widget_Base{
	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'pbmit_ptable_element';
	}
	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return esc_attr__( 'Xinterio Pricing Table Element', 'xinterio' );
	}
	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'fas fa-dollar-sign';
	}
	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'xinterio_category' ];
	}
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}
	protected function register_controls() {
		// Style
		$this->start_controls_section(
			'style_section',
			[
				'label'	=> esc_attr__( 'Select Style', 'xinterio' ),
				'tab'	=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select Pricing Table View Style', 'xinterio' ),
				'description'	=> esc_attr__( 'Select Pricing Table View style.', 'xinterio' ),
				'type'			=> 'pbmit_imgselect',
				'label_block'	=> true,
				'thumb_width'	=> '110px',
				'default'		=> '1',
				'options'		=> pbmit_element_template_list( 'pricing-table', true ),
			]
		);
		$this->end_controls_section();
		// HTML Tags
		$this->start_controls_section(
			'advanced_section',
			[
				'label'	=> pbmit_esc_kses('<img class="pbmit-tab-small-logo" src="'.get_template_directory_uri() . '/includes/images/pbm-small-logo.png" /> ') . esc_attr__( 'Tag & Gap Settings', 'xinterio' ),
				'tab'	=> Controls_Manager::TAB_ADVANCED,
			]
		);
		$this->add_control(
			'tag_options',
			[
				'label'		=> esc_attr__( 'Tags for SEO', 'xinterio' ),
				'type'		=> Controls_Manager::HEADING,
				'separator'	=> 'before',
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'		=> esc_attr__( 'Heading Tag', 'xinterio' ),
				'type'		=> Controls_Manager::SELECT,
				'options'	=> [
					'h1'		=> esc_attr( 'H1' ),
					'h2'		=> esc_attr( 'H2' ),
					'h3'		=> esc_attr( 'H3' ),
					'h4'		=> esc_attr( 'H4' ),
					'h5'		=> esc_attr( 'H5' ),
					'h6'		=> esc_attr( 'H6' ),
					'div'		=> esc_attr( 'DIV' ),
				],
				'default'	=> esc_attr( 'h2' ),
			]
		);
		$this->add_control(
			'subtitle_tag',
			[
				'label'		=> esc_attr__( 'Subheading Tag', 'xinterio' ),
				'type'		=> Controls_Manager::SELECT,
				'options'	=> [
					'h1'		=> esc_attr( 'H1' ),
					'h2'		=> esc_attr( 'H2' ),
					'h3'		=> esc_attr( 'H3' ),
					'h4'		=> esc_attr( 'H4' ),
					'h5'		=> esc_attr( 'H5' ),
					'h6'		=> esc_attr( 'H6' ),
					'div'		=> esc_attr( 'DIV' ),
				],
				'default'	=> esc_attr( 'h4' ),
			]
		);
		$this->end_controls_section();
		// Highlight Column
		$this->start_controls_section(
			'highlight_col_section',
			[
				'label'	=> esc_attr__( 'Highlight Column', 'xinterio' ),
			]
		);
		$this->add_control(
			'highlight_col',
			[
				'label'			=> esc_attr__( 'Highlight Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Select column which is highlighted in pricing table', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( 'First Column', 'xinterio' ),
					'2'				=> esc_attr__( 'Second Column', 'xinterio' ),
					'3'				=> esc_attr__( 'Third Column', 'xinterio' ),
					'4'				=> esc_attr__( 'Fourth Column', 'xinterio' ),
					'5'				=> esc_attr__( 'Fifth Column', 'xinterio' ),
				],
				'default'		=> esc_attr( '2' ),
			]
		);
		$this->add_control(
			'highlight_text',
			[
				'label'			=> esc_attr__( 'Highlight Text', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active' 		=> true,
				],
				'placeholder'	=> esc_attr__( 'This will appear as special text', 'xinterio' ),
				'default'		=> esc_attr( 'popular', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->end_controls_section();
		for( $x=1; $x<=5; $x++ ){
			$default_heading	= '';
			$default_price		= '';
			if( $x == 1 ){
				$default_heading = esc_attr__( 'Basic Plan', 'xinterio' );
				$default_price	 = esc_attr__( '27', 'xinterio' );

			} else if( $x == 2 ){
				$default_heading = esc_attr__( 'Pro Plan', 'xinterio' );
				$default_price	 = esc_attr__( '47', 'xinterio' );

			} else if( $x == 3 ){
				$default_heading = esc_attr__( 'Enterprise', 'xinterio' );
				$default_price	 = esc_attr__( '99', 'xinterio' );

			}
			//Content
			$this->start_controls_section(
				$x.'_col_section',
				[
					'label' => sprintf( esc_attr__( '%1$s Column in Pricing Table', 'xinterio' ) , pbmit_ordinal($x) ) ,
				]
				);
			$this->add_control(
				$x.'_heading',
				[
					'label'			=> esc_attr__( 'Heading', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'default'		=> esc_attr( $default_heading ),
					'description'	=> esc_attr__( 'Enter text used as main heading. This will be plan title like "Basic", "Pro" etc.', 'xinterio' ),
					'label_block'	=> true,
				]
			);
			$this->add_control(
				$x.'_price',
				[
					'label'			=> esc_attr__( 'Price', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'default'		=> esc_attr( $default_price ),
					'description'	=> esc_attr__( 'Enter Price.', 'xinterio' ),
				]
			);
			$this->add_control(
				$x.'_cur_symbol',
				[
					'label'			=> esc_attr__( 'Currency symbol', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'default'		=> esc_attr( '$' ),
					'description'	=> esc_attr__( 'Enter currency symbol', 'xinterio' ),
				]
			);
			$this->add_control(
				$x.'_cur_symbol_position',
				[
					'label'			=> esc_html__( 'Currency Symbol position', 'xinterio' ),
					'description'	=> esc_html__( 'Select currency position.', 'xinterio' ),
					'type'			=> Controls_Manager::SELECT,
					'default'		=> esc_attr('before'),
					'options'		=> [
						'after'			=> esc_attr__( 'After Price', 'xinterio' ),
						'before'		=> esc_attr__( 'Before Price', 'xinterio' ),
					],
				]
			);
			$this->add_control(
				$x.'_price_frequency',
				[
					'label'			=> esc_attr__( 'Price Frequency', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'default'		=> esc_attr__( '/ Mo', 'xinterio' ),
					'description'	=> esc_attr__( 'Enter currency frequency like "Monthly", "Yearly" or "Weekly" etc.', 'xinterio' ),
					'separator'		=> 'after',
				]
			);
			$this->add_control(
				$x.'_btn_text',
				[
					'label'			=> esc_attr__( 'Button Text', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'default'		=> esc_attr__( 'Purchase Now', 'xinterio' ),
					'description'	=> esc_attr__( 'Like "Read More" or "Buy Now".', 'xinterio' ),
				]
			);
			$this->add_control(
				$x.'_btn_link',
				[
					'label'			=> esc_attr__( 'Button Link', 'xinterio' ),
					'type'			=> Controls_Manager::URL,
					'default'		=> array (
						'url'				=> '#',
						'is_external'		=> '',
						'nofollow'			=> '',
						'custom_attributes'	=> '',
					),
					'description'	=> esc_attr__( 'Set link for button', 'xinterio' ),
					'separator'		=> 'after',
				]
			);
			$repeater = new Repeater();
			$repeater->add_control(
				'text',
				[
					'label'			=> esc_attr__( 'Line Label', 'xinterio' ),
					'type'			=> Controls_Manager::TEXT,
					'label_block'	=> true,
				]
			);
			$repeater->add_control(
				'icon',
				[
					'label'		=> esc_attr__( 'Icon', 'xinterio' ),
					'type'		=> Controls_Manager::ICONS,
					'default'	=> [
						'value'		=> 'fas fa-check',
						'library'	=> 'fa-solid',
					],
				]
			);
			$this->add_control(
				$x.'_lines',
				[
					'label'			=> esc_attr__( 'Each Line (Features)', 'xinterio' ),
					'description'	=> esc_attr__( 'Enter features that will be shown in spearate lines.', 'xinterio' ),
					'type'			=> Controls_Manager::REPEATER,
					'fields'		=> $repeater->get_controls(),
					'default'		=> [
						[
							'text'		=> esc_attr__( 'Individuals & small projects', 'xinterio' ),
						],
						[
							'text'		=> esc_attr__( 'Access to design features', 'xinterio' ),
						],
						[
							'text'		=> esc_attr__( 'Limited library of decorative items', 'xinterio' ),
						],
						[
							'text'		=> esc_attr__( 'Email support', 'xinterio' ),
						],
						[
							'text'		=> esc_attr__( 'Monthly updates', 'xinterio' ),
						],
					],
					'title_field'	=> '{{{ text }}}',
				]
			);
			$this->end_controls_section();
		} // end for loop
		// Heading and Subheading
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'Heading and Subheading', 'xinterio' ),
			]
		);
		$this->add_control(
			'title_animation',
			[
				'label'			=> esc_attr__( 'Heading Animation', 'xinterio' ),
				'description'	=> esc_attr__( 'Select Heading Text Animation View style.', 'xinterio' ) . ' ' . pbmit_esc_kses('<br><a target="_blank" href="' . esc_url('https://xinterio-demo.pbminfotech.com/demo1/element/#heading-animations') . '">' . esc_attr__( 'See all anmiation demo here.', 'xinterio' ) . '</a>' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '4',
				'options'		=> [
					'4'				=> esc_attr__( 'No animation', 'xinterio' ),
					'1'				=> esc_attr__( 'Animation Style 1', 'xinterio' ),
					'2'				=> esc_attr__( 'Animation Style 2', 'xinterio' ),
					'3'				=> esc_attr__( 'Animation Style 3', 'xinterio' ),
				],
				'separator'		=> 'before',
			]
		);
		$this->add_control(
			'title',
			[
				'label'			=> esc_attr__( 'Heading', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Our Plans', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter your heading', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'title_link',
			[
				'label'			=> esc_attr__( 'Heading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'			=> esc_attr__( 'Subheading', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'dynamic'		=> [
					'active'		=> true,
				],
				'placeholder'	=> esc_attr__( 'Enter your subtitle', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle_link',
			[
				'label'			=> esc_attr__( 'Subheading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'desc',
			[
				'label'			=> esc_attr__( 'Description', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_attr__( 'Type your description here', 'xinterio' ),
			]
		);
		$this->add_control(
			'reverse_title',
			[
				'label'			=> esc_attr__( 'Reverse Heading', 'xinterio' ),
				'description'	=> esc_attr__( 'Show Subheading before Heading', 'xinterio' ),
				'type'			=> Controls_Manager::SWITCHER,
				'label_on'		=> esc_attr__( 'Yes', 'xinterio' ),
				'label_off'		=> esc_attr__( 'No', 'xinterio' ),
				'return_value'	=> 'yes',
				'default'		=> '',
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label'		=> esc_attr__( 'Alignment', 'xinterio' ),
				'type'		=> Controls_Manager::CHOOSE,
				'options'	=> [
					'left'		=> [
						'title'		=> esc_attr__( 'Left', 'xinterio' ),
						'icon'		=> 'fa fa-align-left',
					],
					'center'	=> [
						'title'		=> esc_attr__( 'Center', 'xinterio' ),
						'icon'		=> 'fa fa-align-center',
					],
					'right'		=> [
						'title'		=> esc_attr__( 'Right', 'xinterio' ),
						'icon'		=> 'fa fa-align-right',
					],
				],
				'selectors'		=> [
					'{{WRAPPER}} .pbmit-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic'		=> [
					'active'		=> true,
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render() {
		$settings	= $this->get_settings_for_display();
		extract($settings);
		$return = '';
		?>
		<div class="pbminfotech-ele pbminfotech-ele-pricing-table pbminfotech-ele-ptable-style-<?php echo esc_attr($style); ?>">
			<?php pbmit_heading_subheading($settings, true); ?>
			<?php
			$columns = array();
			for ($x = 0; $x <= 5; $x++) {
				if( !empty( $settings[$x.'_heading'] ) ){
					$columns[$x] = $x;
				}
			}
			$col_start_div	= '';
			$col_end_div	= '';
			if ($style != '2'){
				if( !empty($columns) ){
					switch( count($columns) ){
						case 1:
							$col_start_div	= '<div class="pbmit-ptable-col col-md-12">';
							$col_end_div	= '</div>';
							break;
						case 2:
							$col_start_div	= '<div class="pbmit-ptable-col col-md-6">';
							$col_end_div	= '</div>';
							break;
						case 3:
							$col_start_div	= '<div class="pbmit-ptable-col col-lg-4 col-md-6 col-sm-12">';
							$col_end_div	= '</div>';
							break;
						case 4:
							$col_start_div	= '<div class="pbmit-ptable-col col-md-3">';
							$col_end_div	= '</div>';
							break;
						case 5:
							$col_start_div	= '<div class="pbmit-ptable-col col-md-20percent">';
							$col_end_div	= '</div>';
							break;
					}
				}
			}
		
			if( $style == '2' ){
				if( !empty($columns) ){
					$col_start_div	= '<div class="pbmit-ptable-col col-md-12">';
					$col_end_div	= '</div>';
				}
			}
			if( !empty($columns) ){
				$return .= '<div class="pbmit-ptable-cols row multi-columns-row">';
				foreach( $columns as $col => $highlight_col ){

					// add highlighted class
					$featured = '';
					if( $settings['highlight_col'] == $col ){
						$col_start_div = str_replace( 'class="', 'class="pbmit-pricing-table-featured-col ', $col_start_div );
						$featured = ( !empty($settings['highlight_col']) ) ? '<div class="pbmit-feature-wrap"><div class="pbmit-ptablebox-featured-w">'.$settings['highlight_text'].'</div></div>' : '' ;
					} else {
						$col_start_div = str_replace( 'class="pbmit-pricing-table-featured-col ', 'class="', $col_start_div );
					}

					// Heading
					$heading = ( !empty($settings[$col.'_heading']) ) ? '<h3 class="pbminfotech-ptable-heading">'.$settings[$col.'_heading'].'</h3><div class="pbminfotech-sep"></div>' : '' ;

					// Currency Symbol
					$currency_symbol = ( !empty($settings[$col.'_cur_symbol']) ) ? '<div class="pbminfotech-ptable-symbol">'.$settings[$col.'_cur_symbol'].'</div>' : '' ;
					// Price Frequency

					$frequency = ( !empty($settings[$col.'_price_frequency']) ) ? '<div class="pbminfotech-ptable-frequency">'.$settings[$col.'_price_frequency'].'</div>' : '' ;
					
					// Price
					$price = ( !empty($settings[$col.'_price']) ) ? '<div class="pbminfotech-ptable-price">'.$settings[$col.'_price'].'</div>' : '' ;

					// Add currently symbol in price
					$price = ( !empty($settings[$col.'_cur_symbol_position']) && $settings[$col.'_cur_symbol_position']=='before' ) ? $currency_symbol.' '.$price : $price.' '.$currency_symbol ;

					// list of features
					$lines_html = '';
					$values  = (array) $settings[$col.'_lines'];
					if( is_array($values) && count($values)>0 ){
						foreach ( $values as $data ) {
							if($data['icon']['library']=='svg'){
								ob_start();
								Icons_Manager::render_icon( $data['icon'] , [ 'aria-hidden' => 'true' ] );
								$list_icon = ob_get_contents();
								ob_end_clean();
								$list_icon		 = '<div class="pbmit-ptable-line-svg">' . $list_icon . '</div>';
								$icon_type_class = 'icon';
							} else {
								ob_start();
								Icons_Manager::render_icon( $data['icon'] , [ 'aria-hidden' => 'true' ] );
								$list_icon = ob_get_contents();
								ob_end_clean();
								wp_enqueue_style( 'elementor-icons-'.$data['icon']['library']);
							}
							$lines_html .= isset( $data['text'] ) ? '<div class="pbmit-ptable-line">'.$list_icon.$data['text'].'</div>' : '';
						}
					}
					// Button
					$button = '';
					if( !empty($settings[$col.'_btn_text']) && !empty($settings[$col.'_btn_link']['url']) ){
						$button = '<div class="pbmit-btn">' . pbmit_link_render($settings[$col.'_btn_link'], 'start' ) . pbmit_esc_kses($settings[$col.'_btn_text']) . pbmit_link_render($settings[$col.'_btn_link'], 'end' ) . '</div>';
					}
					// Template output
					$return .= $col_start_div;
					ob_start();
					include( get_template_directory() . '/theme-parts/pricing-table/pricing-table-style-'.esc_attr($style).'.php' );
					$return .= ob_get_contents();
					ob_end_clean();
					$return .= $col_end_div;
				}
				$return .= '</div>';
			}
			echo pbmit_esc_kses($return);
			?>
		</div><!-- pbminfotech-ele pbminfotech-ele-pricing-table -->
		<?php
	}
	protected function content_template() {}
	
	protected function select_category() {
		$category = get_terms( array( 'taxonomy' => 'pbmit-ptable-category', 'hide_empty' => false ) );
		$cat = array();
		foreach( $category as $item ) {
			$cat_count = get_category( $item );
			if( $item ) {
				$cat[$item->slug] = $item->name . ' ('.$cat_count->count.')';
			}
		}
		return $cat;
	}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new PBMIT_PTableElement() );