<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)
/**
 * Widget Name: Section Heading 
 */
class PBMIT_TabsSpecialElement extends Widget_Base{
 	/**
	 * Get widget name.
	 *
	 * Retrieve tabs widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pbmit_tabs_special_element';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve tabs widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'xinterio Tabs Special Element', 'xinterio' );
	}
	/**
	 * Get widget icon.
	 *
	 * Retrieve tabs widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-border-none';
	}
	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'xinterio_category' ];
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'tabs', 'accordion', 'toggle' ];
	}
	protected function register_controls() {

		// Heading and Subheading
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'Heading and Subheading', 'xinterio' ),
			]
		);
		$this->add_control(
			'title_animation',
			[
				'label'			=> esc_attr__( 'Heading Animation', 'xinterio' ),
				'description'	=> esc_attr__( 'Select Heading Text Animation View style.', 'xinterio' ) . ' ' . pbmit_esc_kses('<br><a target="_blank" href="' . esc_url('https://xinterio-demo.pbminfotech.com/demo1/element/#heading-animations') . '">' . esc_attr__( 'See all anmiation demo here.', 'xinterio' ) . '</a>' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '4',
				'options'		=> [
					'4'				=> esc_attr__( 'No animation', 'xinterio' ),
					'1'				=> esc_attr__( 'Animation Style 1', 'xinterio' ),
					'2'				=> esc_attr__( 'Animation Style 2', 'xinterio' ),
					'3'				=> esc_attr__( 'Animation Style 3', 'xinterio' ),
				],
				'separator'		=> 'before',
			]
		);
		$this->add_control(
			'title',
			[
				'label'			=> esc_attr__( 'Heading', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Our Tabs', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter your heading', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'title_link',
			[
				'label'			=> esc_attr__( 'Heading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'			=> esc_attr__( 'Subheading', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'dynamic'		=> [
					'active'		=> true,
				],
				'placeholder'	=> esc_attr__( 'Enter your subtitle', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle_link',
			[
				'label'			=> esc_attr__( 'Subheading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'desc',
			[
				'label'			=> esc_attr__( 'Description', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_attr__( 'Type your description here', 'xinterio' ),
			]
		);
		$this->add_control(
			'reverse_title',
			[
				'label'			=> esc_attr__( 'Reverse Heading', 'xinterio' ),
				'description'	=> esc_attr__( 'Show Subheading before Heading', 'xinterio' ),
				'type'			=> Controls_Manager::SWITCHER,
				'label_on'		=> esc_attr__( 'Yes', 'xinterio' ),
				'label_off'		=> esc_attr__( 'No', 'xinterio' ),
				'return_value'	=> 'yes',
				'default'		=> '',
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label'			=> esc_attr__( 'Alignment', 'xinterio' ),
				'type'			=> Controls_Manager::CHOOSE,
				'options'		=> [
					'left'			=> [
						'title'			=> esc_attr__( 'Left', 'xinterio' ),
						'icon'			=> 'fa fa-align-left',
					],
					'center'		=> [
						'title'			=> esc_attr__( 'Center', 'xinterio' ),
						'icon'			=> 'fa fa-align-center',
					],
					'right'			=> [
						'title'			=> esc_attr__( 'Right', 'xinterio' ),
						'icon'			=> 'fa fa-align-right',
					],
				],
				'prefix_class'	=> 'pbmit-ele-header-align-',
				'selectors'		=> [
					'{{WRAPPER}} .pbmit-heading-subheading' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_attr( 'Tabs Option', 'xinterio' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'tab_title',
			[
				'label'			=> esc_attr( 'Title', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> esc_attr( 'Tab Title', 'xinterio' ),
				'placeholder'	=> esc_attr( 'Tab Title', 'xinterio' ),
				'label_block'	=> true,
			]
		);	
		$repeater->add_control(
			'tab_image',
			[
				'label'			=> esc_attr__( 'Select Tab Image', 'xinterio' ),
				'description'	=> esc_attr__( 'This image will appear at icon position. Recommended size is 300x300 px transparent PNG file.', 'xinterio' ),
				'type'			=> \Elementor\Controls_Manager::MEDIA,
				'default'		=> [
					'url'			=> get_template_directory_uri() . '/images/icon-img.png',
				],
			]
		);
		$repeater->add_control(
			'tab_highlight_text',
			[
				'label'			=> esc_attr__( 'Tab Highlight text', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> false,
				],
				'default'		=> esc_attr__( '25+ Year Of Experience', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_heading',
			[
				'label'			=> esc_attr__( 'Tab Heading', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Creating The Art Of Stylish Living.', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_content',
			[
				'label'			=> esc_attr( 'Tab Content', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'default'		=> esc_attr( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even.', 'xinterio' ),
				'placeholder'	=> esc_attr( 'Tab Content', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_text_01',
			[
				'label'			=> esc_attr__( 'Tab Line1', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Experience Time-served Engineers', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_text_02',
			[
				'label'			=> esc_attr__( 'Tab Line2', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Commitment of customer service', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_text_03',
			[
				'label'			=> esc_attr__( 'Tab Line3', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> false,
				],
				'default'		=> esc_attr__( 'Commitment to talking the stress out of your project', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'tab_text_04',
			[
				'label'			=> esc_attr__( 'Tab Line4', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> false,
				],
				'default'		=> esc_attr__( 'Flexible With any structure of the building', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter Text Here', 'xinterio' ),
				'label_block'	=> true,
			]
		);

		// Button Option	
		$repeater->add_control(
			'btn_title',
			[
				'label'			=> esc_attr__( 'Button Title', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> esc_attr__( 'Our Service', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter button title here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label'			=> esc_attr__( 'Button Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
				'default'		=> array (
					'url'				=> '#',
					'is_external'		=> '',
					'nofollow'			=> '',
					'custom_attributes'	=> '',
				),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label'			=> esc_attr( 'Tabs Items', 'xinterio' ),
				'type'			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default'		=> [
					[
						'tab_image'		=> get_template_directory_uri() . '/images/static-box.jpg',
						'tab_heading'	=> esc_attr( 'Creating The Art Of Stylish Living', 'xinterio' ),
						'tab_content'	=> esc_attr( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even.', 'xinterio' ),
						'tab_highlight_text'	=> esc_attr( '25+ Year Of Experience', 'xinterio' ),
						'tab_title'		=> esc_attr( 'Our Mission', 'xinterio' ),
						'tab_text_01'	=> esc_attr( 'Experience Time-served Engineers.', 'xinterio' ),
						'tab_text_02'	=> esc_attr( 'Commitment of customer service', 'xinterio' ),
						'tab_text_03'	=> esc_attr( 'Commitment to talking the stress out of your project.', 'xinterio' ),
						'tab_text_04'	=> esc_attr( 'Flexible With any structure of the building.', 'xinterio' ),
					],
					[
						'tab_image'		=> get_template_directory_uri() . '/images/static-box.jpg',
						'tab_heading'	=> esc_attr( 'Creating The Art Of Stylish Living', 'xinterio' ),
						'tab_content'	=> esc_attr( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even.', 'xinterio' ),
						'tab_highlight_text'	=> esc_attr( '25+ Year Of Experience', 'xinterio' ),
						'tab_title'		=> esc_attr( 'Our Vision', 'xinterio' ),
						'tab_text_01'	=> esc_attr( 'Experience Time-served Engineers.', 'xinterio' ),
						'tab_text_02'	=> esc_attr( 'Commitment of customer service', 'xinterio' ),
						'tab_text_03'	=> esc_attr( 'Commitment to talking the stress out of your project.', 'xinterio' ),
						'tab_text_04'	=> esc_attr( 'Flexible With any structure of the building.', 'xinterio' ),
					],
					[
						'tab_image'		=> get_template_directory_uri() . '/images/static-box.jpg',
						'tab_heading'	=> esc_attr( 'Creating The Art Of Stylish Living', 'xinterio' ),
						'tab_content'	=> esc_attr( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even.', 'xinterio' ),
						'tab_highlight_text'	=> esc_attr( '25+ Year Of Experience', 'xinterio' ),
						'tab_title'		=> esc_attr( 'Our Value', 'xinterio' ),
						'tab_text_01'	=> esc_attr( 'Experience Time-served Engineers.', 'xinterio' ),
						'tab_text_02'	=> esc_attr( 'Commitment of customer service', 'xinterio' ),
						'tab_text_03'	=> esc_attr( 'Commitment to talking the stress out of your project.', 'xinterio' ),
						'tab_text_04'	=> esc_attr( 'Flexible With any structure of the building.', 'xinterio' ),
					],
				],
				'title_field'	=> '{{{ tab_title }}}',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
<div class = "pbmit-tab-special">
		<div class="pbmit-element-posts-wrapper row multi-columns-row">	
			<div class="pbmit-contentbox col-md-12 col-sm-12">
				<div class="pbmit-ele-header-area">
					<?php pbmit_heading_subheading($settings, true); ?>
				</div>

				<div class="pbmit-tabs">
					<?php if ( $settings['tabs'] ) : ?>
					<ul class="pbmit-tabs-heading">
						<?php $i = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
							<?php $active_li_class = ( $i==1 ) ? 'pbmit-tab-li-active' : '' ; ?>
						<li class="pbmit-tab-link <?php echo esc_attr($active_li_class); ?>" data-pbmit-tab="<?php echo esc_attr($i); ?>"><span><?php echo esc_html($tabs['tab_title']); ?></span></li>
						<?php $i++; } ?>
					</ul>
					<div class="pbmit-tab-content-wrapper">
						<?php $j = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
							<?php $active_class = ( $j==1 ) ? 'pbmit-tab-active' : '' ; ?>
							<div class="pbmit-tab-content pbmit-tab-content-<?php echo esc_attr($j); ?> <?php echo esc_attr($active_class); ?>">
								<div class="pbmit-tab-content-title" data-pbmit-tab="<?php echo esc_attr($j); ?>"><?php echo esc_html($tabs['tab_title']); ?></div>

								<div class="pbmit-tab-content-inner">
									<?php
									$line1 = $line2 = $line3 = $line4 = $icon_html = $tab_image_html =  $icon_html_code = $button_html = '';

									//Tab Image
									if( !empty($tabs['tab_image']['url']) ){
										$icon_alt	= (!empty($settings['tab_title'])) ? trim($settings['tab_title']) : esc_attr__('image', 'xinterio');
										$tab_image_html .= '<img src="'.$tabs['tab_image']['url'].'" alt="'.esc_attr($icon_alt).'" />';
									}
									//Highlight Text
									$tab_highlight_text	= ( !empty($tabs['tab_highlight_text']) ) ? '<div class="pbmit-tab-highlight"><h3>'.pbmit_esc_kses($tabs['tab_highlight_text']).'</h3></div>' : '' ;

									//Heading
									$tab_heading	= ( !empty($tabs['tab_heading']) ) ? '<div class="pbmit-tab-heading"><h3>'.esc_html($tabs['tab_heading']).'</h3></div>' : '' ;

									//Description
									$tab_content	= ( !empty($tabs['tab_content']) ) ? '<div class="pbmit-tab-desc">'.esc_html($tabs['tab_content']).'</div>' : '' ;

									?>

									<div class= "pbmit-image-content-wraper row ">
										
										<div class="pbmit-tab-inner-content col-xl-7">
											<?php
												// Tab Text
												$line1 .= ( !empty($tabs['tab_text_01']) ) ? '<li>'.esc_html($tabs['tab_text_01']).'</li>' : '' ;
												$line2 .= ( !empty($tabs['tab_text_02']) ) ? '<li>'.esc_html($tabs['tab_text_02']).'</li>' : '' ;
												$line3 .= ( !empty($tabs['tab_text_03']) ) ? '<li>'.esc_html($tabs['tab_text_03']).'</li>' : '' ;
												$line4 .= ( !empty($tabs['tab_text_04']) ) ? '<li>'.esc_html($tabs['tab_text_04']).'</li>' : '' ;
											?>
											<?php echo pbmit_esc_kses( $tab_heading ); ?>
											<?php echo pbmit_esc_kses( $tab_content ); ?>
											<?php echo $tab_highlight_text ?>
											<ul>
												<?php echo pbmit_esc_kses($line1); ?>
												<?php echo pbmit_esc_kses($line2); ?>
												<?php echo pbmit_esc_kses($line3); ?>
												<?php echo pbmit_esc_kses($line4); ?>
											</ul>

											<?php
											// Button
											if( !empty($tabs['btn_title']) && !empty($tabs['btn_link']['url']) ){
												$button_html = '<div class="pbmit-ihbox-btn">' . pbmit_link_render($tabs['btn_link'], 'start' ) . pbmit_esc_kses($tabs['btn_title']) . pbmit_link_render($tabs['btn_link'], 'end' ) . '</div>';
											}
											echo pbmit_esc_kses( $button_html );?>
											
										</div>
										<div class="pbmit-tab-image-wrap col-xl-5">
											<?php echo pbmit_esc_kses( $tab_image_html ); ?>
										</div>
									</div>
								</div>

							</div>
						<?php $j++; } ?>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
		<?php
	}
	protected function content_template() {}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new PBMIT_TabsSpecialElement() );